/*
 * Decompiled with CFR 0.152.
 */
package com.wolfram.alpha.impl;

import com.wolfram.alpha.WAException;
import com.wolfram.alpha.WAInfo;
import com.wolfram.alpha.WAPod;
import com.wolfram.alpha.WAPodState;
import com.wolfram.alpha.WASound;
import com.wolfram.alpha.WASubpod;
import com.wolfram.alpha.impl.WAInfoImpl;
import com.wolfram.alpha.impl.WAPodStateImpl;
import com.wolfram.alpha.impl.WASoundImpl;
import com.wolfram.alpha.impl.WASubpodImpl;
import com.wolfram.alpha.net.HttpProvider;
import com.wolfram.alpha.net.URLFetcher;
import com.wolfram.alpha.visitor.Visitable;
import com.wolfram.alpha.visitor.Visitor;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class WAPodImpl
implements WAPod,
Visitable,
Serializable {
    private transient HttpProvider http;
    private transient File tempDir;
    private String title;
    private boolean error;
    private String scanner;
    private int position;
    private String id;
    private String asyncURL;
    private WAException asyncException;
    private WASubpodImpl[] subpods = WASubpodImpl.EMPTY_ARRAY;
    private WAPodStateImpl[] podstates = WAPodStateImpl.EMPTY_ARRAY;
    private WAInfoImpl[] infos = WAInfoImpl.EMPTY_ARRAY;
    private WASoundImpl[] sounds = WASoundImpl.EMPTY_ARRAY;
    private transient Object userData;
    static final WAPodImpl[] EMPTY_ARRAY = new WAPodImpl[0];
    private static final long serialVersionUID = 7267507688992616456L;

    WAPodImpl(Element thisElement, HttpProvider http, File tempDir) throws WAException {
        this.http = http;
        this.tempDir = tempDir;
        this.createFromDOM(thisElement);
    }

    private synchronized void createFromDOM(Element thisElement) throws WAException {
        this.error = thisElement.getAttribute("error").equals("true");
        if (!this.error) {
            NodeList soundElements;
            int numSoundElements;
            NodeList infosElements;
            int numInfosElements;
            this.title = thisElement.getAttribute("title");
            this.scanner = thisElement.getAttribute("scanner");
            try {
                this.position = Integer.parseInt(thisElement.getAttribute("position"));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            this.id = thisElement.getAttribute("id");
            this.asyncURL = thisElement.getAttribute("async");
            if (this.asyncURL.equals("")) {
                this.asyncURL = null;
            }
            NodeList subpodElements = thisElement.getElementsByTagName("subpod");
            int numSubpods = subpodElements.getLength();
            this.subpods = new WASubpodImpl[numSubpods];
            for (int i = 0; i < numSubpods; ++i) {
                this.subpods[i] = new WASubpodImpl((Element)subpodElements.item(i), this.http, this.tempDir);
            }
            NodeList podstatesElements = thisElement.getElementsByTagName("states");
            int numStatesElements = podstatesElements.getLength();
            if (numStatesElements > 0) {
                Element statesElement = (Element)podstatesElements.item(0);
                NodeList subElements = statesElement.getChildNodes();
                int numSubElements = subElements.getLength();
                ArrayList<Node> stateAndStatelistNodes = new ArrayList<Node>(numSubElements);
                for (int i = 0; i < numSubElements; ++i) {
                    Node child = subElements.item(i);
                    String name = child.getNodeName();
                    if (!"state".equals(name) && !"statelist".equals(name)) continue;
                    stateAndStatelistNodes.add(child);
                }
                int numStates = stateAndStatelistNodes.size();
                this.podstates = new WAPodStateImpl[numStates];
                for (int i = 0; i < numStates; ++i) {
                    this.podstates[i] = new WAPodStateImpl((Element)stateAndStatelistNodes.get(i));
                }
            }
            if ((numInfosElements = (infosElements = thisElement.getElementsByTagName("infos")).getLength()) > 0) {
                Element infosElement = (Element)infosElements.item(0);
                NodeList subElements = infosElement.getChildNodes();
                int numSubElements = subElements.getLength();
                ArrayList<Node> infoNodes = new ArrayList<Node>(numSubElements);
                for (int i = 0; i < numSubElements; ++i) {
                    Node child = subElements.item(i);
                    String name = child.getNodeName();
                    if (!"info".equals(name)) continue;
                    infoNodes.add(child);
                }
                int numInfos = infoNodes.size();
                this.infos = new WAInfoImpl[numInfos];
                for (int i = 0; i < numInfos; ++i) {
                    this.infos[i] = new WAInfoImpl((Element)infoNodes.get(i), this.http, this.tempDir);
                }
            }
            if ((numSoundElements = (soundElements = thisElement.getElementsByTagName("sounds")).getLength()) > 0) {
                Element soundElement = (Element)soundElements.item(0);
                NodeList subElements = soundElement.getChildNodes();
                int numSubElements = subElements.getLength();
                ArrayList<Node> soundNodes = new ArrayList<Node>(numSubElements);
                for (int i = 0; i < numSubElements; ++i) {
                    Node child = subElements.item(i);
                    String name = child.getNodeName();
                    if (!"sound".equals(name)) continue;
                    soundNodes.add(child);
                }
                int numSounds = soundNodes.size();
                this.sounds = new WASoundImpl[numSounds];
                for (int i = 0; i < numSounds; ++i) {
                    this.sounds[i] = new WASoundImpl((Element)soundNodes.get(i), this.http, this.tempDir);
                }
            }
        }
    }

    public synchronized String getTitle() {
        return this.title;
    }

    public synchronized boolean isError() {
        return this.error;
    }

    public synchronized int getNumSubpods() {
        return this.subpods.length;
    }

    public synchronized String getScanner() {
        return this.scanner;
    }

    public synchronized int getPosition() {
        return this.position;
    }

    public synchronized String getID() {
        return this.id;
    }

    public synchronized String getAsyncURL() {
        return this.asyncURL;
    }

    public synchronized WASubpod[] getSubpods() {
        return this.subpods;
    }

    public synchronized WAPodState[] getPodStates() {
        return this.podstates;
    }

    public synchronized WAInfo[] getInfos() {
        return this.infos;
    }

    public synchronized WASound[] getSounds() {
        return this.sounds;
    }

    public synchronized WAException getAsyncException() {
        return this.asyncException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireImages() throws WAException {
        WASubpodImpl[] sps;
        WAPodImpl wAPodImpl = this;
        synchronized (wAPodImpl) {
            sps = this.subpods;
        }
        for (WASubpodImpl sub : sps) {
            sub.acquireImage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishAsync() throws WAException {
        String url;
        WAException newAsyncException = null;
        WAPodImpl wAPodImpl = this;
        synchronized (wAPodImpl) {
            url = this.asyncURL;
            if (url != null) {
                this.asyncException = null;
            }
        }
        if (url != null) {
            try {
                URLFetcher fetcher = new URLFetcher(new URL(url), null, this.http, null);
                fetcher.fetch();
                if (fetcher.wasCancelled()) {
                    throw new WAException("Download of url " + this.asyncURL + " was cancelled");
                }
                if (fetcher.getException() != null) {
                    throw new WAException(fetcher.getException());
                }
                byte[] bytes = fetcher.getBytes();
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document doc = builder.parse(new ByteArrayInputStream(bytes));
                WAPodImpl wAPodImpl2 = this;
                synchronized (wAPodImpl2) {
                    this.createFromDOM(doc.getDocumentElement());
                    this.asyncURL = null;
                }
                this.acquireImages();
            }
            catch (ParserConfigurationException e) {
                newAsyncException = new WAException(e);
            }
            catch (FactoryConfigurationError e) {
                newAsyncException = new WAException(e);
            }
            catch (IOException e) {
                newAsyncException = new WAException(e);
            }
            catch (SAXException e) {
                newAsyncException = new WAException(e);
            }
            if (newAsyncException != null) {
                wAPodImpl = this;
                synchronized (wAPodImpl) {
                    this.asyncException = newAsyncException;
                }
                throw newAsyncException;
            }
        }
    }

    public synchronized void setUserData(Object obj) {
        this.userData = obj;
    }

    public synchronized Object getUserData() {
        return this.userData;
    }

    public synchronized int hashCode() {
        int result = 17;
        result = 37 * result + this.title.hashCode();
        result = 37 * result + (this.error ? 1 : 0);
        if (this.asyncException != null) {
            result = 37 * result + this.asyncException.hashCode();
        }
        if (this.userData != null) {
            result = 37 * result + this.userData.hashCode();
        }
        for (WASubpodImpl wASubpodImpl : this.subpods) {
            result = 37 * result + ((Object)wASubpodImpl).hashCode();
        }
        for (Visitable visitable : this.sounds) {
            result = 37 * result + visitable.hashCode();
        }
        return result;
    }

    public void accept(Visitor v) {
        v.visit(this);
        for (WASubpodImpl subpod : this.subpods) {
            subpod.accept(v);
        }
    }
}

