/*
 * Decompiled with CFR 0.152.
 */
package com.wolfram.alpha.impl;

import com.wolfram.alpha.WAException;
import com.wolfram.alpha.WAPodState;
import com.wolfram.alpha.visitor.Visitable;
import com.wolfram.alpha.visitor.Visitor;
import java.io.Serializable;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WAPodStateImpl
implements WAPodState,
Visitable,
Serializable {
    private String[] names = EMPTY_STRING_ARRAY;
    private String[] inputs = EMPTY_STRING_ARRAY;
    private String current = null;
    private int currentIndex = -1;
    private long id = 0L;
    static final WAPodStateImpl[] EMPTY_ARRAY = new WAPodStateImpl[0];
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final String[] DEFAULT_NAME_ARRAY = new String[]{""};
    private static final long serialVersionUID = -253401729369983369L;

    WAPodStateImpl(Element thisElement) throws WAException {
        this.createFromDOM(thisElement);
    }

    private WAPodStateImpl() {
    }

    WAPodStateImpl(String input) {
        this(input, 0L);
    }

    public WAPodStateImpl(String input, long id) {
        this.inputs = new String[]{input};
        this.names = DEFAULT_NAME_ARRAY;
        this.currentIndex = 0;
        this.id = id;
    }

    private synchronized void createFromDOM(Element thisElement) throws WAException {
        String nodeName = thisElement.getNodeName();
        if ("state".equals(nodeName)) {
            String name = thisElement.getAttribute("name");
            String input = thisElement.getAttribute("input");
            if ("".equals(input)) {
                input = name;
            }
            this.names = new String[]{name};
            this.inputs = new String[]{input};
        } else if ("statelist".equals(nodeName)) {
            String cur = thisElement.getAttribute("value");
            if (!"".equals(cur)) {
                this.current = cur;
            }
            NodeList states = thisElement.getChildNodes();
            int numStates = states.getLength();
            ArrayList<Node> stateElements = new ArrayList<Node>(numStates);
            for (int i = 0; i < numStates; ++i) {
                Node stateNode = states.item(i);
                if (!"state".equals(stateNode.getNodeName())) continue;
                stateElements.add(stateNode);
            }
            int numStatesFound = stateElements.size();
            this.names = new String[numStatesFound];
            this.inputs = new String[numStatesFound];
            for (int i = 0; i < numStatesFound; ++i) {
                Element stateElement = (Element)stateElements.get(i);
                String name = stateElement.getAttribute("name");
                String input = stateElement.getAttribute("input");
                if ("".equals(input)) {
                    input = name;
                }
                this.names[i] = name;
                this.inputs[i] = input;
            }
            this.computeID();
        }
    }

    public String[] getNames() {
        return this.names;
    }

    public String[] getInputs() {
        return this.inputs;
    }

    public int getCurrentIndex() {
        if (this.currentIndex >= 0) {
            return this.currentIndex;
        }
        if (this.current == null) {
            this.currentIndex = 0;
        } else {
            for (int i = 0; i < this.names.length; ++i) {
                if (!this.current.equals(this.names[i])) continue;
                this.currentIndex = i;
                break;
            }
        }
        return this.currentIndex;
    }

    public WAPodState setCurrentIndex(int index) {
        WAPodStateImpl newState = new WAPodStateImpl();
        newState.names = this.names;
        newState.inputs = this.inputs;
        newState.currentIndex = index;
        newState.current = newState.names[index];
        newState.computeID();
        return newState;
    }

    public long getID() {
        return this.id;
    }

    private void computeID() {
        this.id = 17L;
        for (String s : this.inputs) {
            this.id += 37L * this.id + (long)s.hashCode();
        }
    }

    public void accept(Visitor v) {
        v.visit(this);
    }
}

