/*
 * Decompiled with CFR 0.152.
 */
package com.wolfram.alpha.impl;

import com.wolfram.alpha.WAPodState;
import com.wolfram.alpha.WAQueryParameters;
import com.wolfram.alpha.impl.WAPodStateImpl;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WAQueryParametersImpl
implements WAQueryParameters,
Serializable {
    protected String input;
    protected String appid;
    protected List<String> formats = new ArrayList<String>(5);
    protected double async = -1.0;
    protected double scanTimeout = -1.0;
    protected double podTimeout = -1.0;
    protected double formatTimeout = -1.0;
    protected int width = -1;
    protected int maxWidth = -1;
    protected int plotWidth = -1;
    protected double magnification = 1.0;
    protected String ip;
    protected String location;
    protected Double latitude;
    protected Double longitude;
    protected Boolean metric;
    protected String currency;
    protected String countryCode;
    protected Boolean allowTranslation;
    protected boolean includeRelatedLinks;
    protected boolean allowReinterpret = true;
    protected String signature;
    protected List<String[]> extraParams = new ArrayList<String[]>(1);
    protected List<String> podTitles = new ArrayList<String>(5);
    protected List<String> podScanners = new ArrayList<String>(5);
    protected List<Integer> podIndices = new ArrayList<Integer>(5);
    protected List<String> includePodIDs = new ArrayList<String>(5);
    protected List<String> excludePodIDs = new ArrayList<String>(5);
    protected List<WAPodState> podStates = new ArrayList<WAPodState>(5);
    protected List<String> assumptions = new ArrayList<String>(5);
    private static final long serialVersionUID = 2222070970297271641L;

    public WAQueryParametersImpl() {
    }

    public WAQueryParametersImpl(WAQueryParameters orig) {
        this.input = orig.getInput();
        this.async = orig.getAsync();
        this.formats.addAll(Arrays.asList(orig.getFormats()));
        this.scanTimeout = orig.getScanTimeout();
        this.podTimeout = orig.getPodTimeout();
        this.formatTimeout = orig.getFormatTimeout();
        this.width = orig.getWidth();
        this.maxWidth = orig.getMaxWidth();
        this.plotWidth = orig.getPlotWidth();
        this.magnification = orig.getMagnification();
        this.ip = orig.getIP();
        this.location = orig.getLocation();
        double[] latlong = orig.getLatLong();
        this.latitude = latlong != null ? Double.valueOf(latlong[0]) : null;
        this.longitude = latlong != null ? Double.valueOf(latlong[1]) : null;
        this.metric = orig.isMetric();
        this.currency = orig.getCurrency();
        this.countryCode = orig.getCountryCode();
        this.allowTranslation = orig.isAllowTranslation();
        this.podTitles.addAll(Arrays.asList(orig.getPodTitles()));
        this.podScanners.addAll(Arrays.asList(orig.getPodScanners()));
        for (int index : orig.getPodIndexes()) {
            this.podIndices.add(new Integer(index));
        }
        this.includePodIDs.addAll(Arrays.asList(orig.getIncludePodIDs()));
        this.excludePodIDs.addAll(Arrays.asList(orig.getExcludePodIDs()));
        this.podStates.addAll(Arrays.asList(orig.getPodStates()));
        this.assumptions.addAll(Arrays.asList(orig.getAssumptions()));
        this.includeRelatedLinks = orig.isRelatedLinks();
        this.allowReinterpret = orig.isReinterpret();
        this.extraParams.addAll(orig.getExtraParams());
    }

    @Override
    public String getInput() {
        return this.input;
    }

    @Override
    public void setInput(String input) {
        this.input = input;
    }

    @Override
    public String[] getFormats() {
        return this.formats.toArray(new String[this.formats.size()]);
    }

    @Override
    public void addFormat(String format) {
        if (!this.formats.contains(format = format.toLowerCase())) {
            this.formats.add(format);
        }
    }

    @Override
    public double getScanTimeout() {
        return this.scanTimeout;
    }

    @Override
    public void setScanTimeout(double timeout) {
        this.scanTimeout = timeout;
    }

    @Override
    public double getPodTimeout() {
        return this.podTimeout;
    }

    @Override
    public void setPodTimeout(double timeout) {
        this.podTimeout = timeout;
    }

    @Override
    public double getFormatTimeout() {
        return this.formatTimeout;
    }

    @Override
    public void setFormatTimeout(double timeout) {
        this.formatTimeout = timeout;
    }

    @Override
    public double getAsync() {
        return this.async;
    }

    @Override
    public void setAsync(double async) {
        this.async = async;
    }

    @Override
    public String getIP() {
        return this.ip;
    }

    @Override
    public void setIP(String ip) {
        this.ip = ip;
    }

    @Override
    public double[] getLatLong() {
        if (this.latitude == null || this.longitude == null) {
            return null;
        }
        return new double[]{this.latitude, this.longitude};
    }

    @Override
    public void setLatLong(String latlong) throws IllegalArgumentException {
        String[] parts = latlong.split(",");
        if (parts.length != 2) {
            throw new IllegalArgumentException("latlong specification must be two numbers separated by a comma");
        }
        this.latitude = new Double(parts[0].trim());
        this.longitude = new Double(parts[1].trim());
    }

    @Override
    public void setLatitude(double latitude) {
        this.latitude = new Double(latitude);
    }

    @Override
    public void setLongitude(double longitude) {
        this.longitude = new Double(longitude);
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public void setLocation(String loc) {
        this.location = loc;
    }

    @Override
    public Boolean isMetric() {
        return this.metric;
    }

    @Override
    public void setMetric(Boolean metric) {
        this.metric = metric;
    }

    @Override
    public String getCurrency() {
        return this.currency;
    }

    @Override
    public void setCurrency(String currency) {
        this.currency = currency;
    }

    @Override
    public String getCountryCode() {
        return this.countryCode;
    }

    @Override
    public void setCountryCode(String code) {
        this.countryCode = code;
    }

    @Override
    public Boolean isAllowTranslation() {
        return this.allowTranslation;
    }

    @Override
    public void setAllowTranslation(Boolean allow) {
        this.allowTranslation = allow;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public int getMaxWidth() {
        return this.maxWidth;
    }

    @Override
    public void setMaxWidth(int width) {
        this.maxWidth = width;
    }

    @Override
    public int getPlotWidth() {
        return this.plotWidth;
    }

    @Override
    public void setPlotWidth(int width) {
        this.plotWidth = width;
    }

    @Override
    public double getMagnification() {
        return this.magnification;
    }

    @Override
    public void setMagnification(double mag) {
        this.magnification = mag;
    }

    @Override
    public String[] getPodTitles() {
        return this.podTitles.toArray(new String[this.podTitles.size()]);
    }

    @Override
    public void addPodTitle(String podtitle) {
        if (!this.podTitles.contains(podtitle)) {
            this.podTitles.add(podtitle);
        }
    }

    @Override
    public void clearPodTitles() {
        this.podTitles.clear();
    }

    @Override
    public int[] getPodIndexes() {
        int[] result = new int[this.podIndices.size()];
        int i = 0;
        for (Integer index : this.podIndices) {
            result[i++] = index;
        }
        return result;
    }

    @Override
    public void addPodIndex(int podindex) {
        Integer index = new Integer(podindex);
        if (!this.podIndices.contains(index)) {
            this.podIndices.add(index);
        }
    }

    @Override
    public void clearPodIndexes() {
        this.podIndices.clear();
    }

    @Override
    public String[] getPodScanners() {
        return this.podScanners.toArray(new String[this.podScanners.size()]);
    }

    @Override
    public void addPodScanner(String podscanner) {
        if (!this.podScanners.contains(podscanner)) {
            this.podScanners.add(podscanner);
        }
    }

    @Override
    public void clearPodScanners() {
        this.podScanners.clear();
    }

    @Override
    public String[] getIncludePodIDs() {
        return this.includePodIDs.toArray(new String[this.includePodIDs.size()]);
    }

    @Override
    public void addIncludePodID(String podid) {
        if (!this.includePodIDs.contains(podid)) {
            this.includePodIDs.add(podid);
        }
    }

    @Override
    public void clearIncludePodIDs() {
        this.includePodIDs.clear();
    }

    @Override
    public String[] getExcludePodIDs() {
        return this.excludePodIDs.toArray(new String[this.excludePodIDs.size()]);
    }

    @Override
    public void addExcludePodID(String podid) {
        if (!this.excludePodIDs.contains(podid)) {
            this.excludePodIDs.add(podid);
        }
    }

    @Override
    public void clearExcludePodIDs() {
        this.excludePodIDs.clear();
    }

    @Override
    public WAPodState[] getPodStates() {
        return this.podStates.toArray(new WAPodState[this.podStates.size()]);
    }

    @Override
    public void addPodState(String podstate) {
        this.addPodState(new WAPodStateImpl(podstate));
    }

    @Override
    public void addPodState(String podstate, long id) {
        this.addPodState(new WAPodStateImpl(podstate, id));
    }

    @Override
    public void addPodState(WAPodState podstate) {
        boolean isReplacingExistingState = false;
        if (podstate.getInputs().length > 1) {
            long newID = podstate.getID();
            ListIterator<WAPodState> iter = this.podStates.listIterator();
            while (iter.hasNext()) {
                WAPodState state = iter.next();
                long id = state.getID();
                if (id != newID) continue;
                iter.set(podstate);
                isReplacingExistingState = true;
                break;
            }
        }
        if (!isReplacingExistingState) {
            this.podStates.add(podstate);
        }
    }

    @Override
    public void clearPodStates() {
        this.podStates.clear();
    }

    @Override
    public String[] getAssumptions() {
        return this.assumptions.toArray(new String[this.assumptions.size()]);
    }

    @Override
    public void addAssumption(String assumption) {
        String newLhs = assumption.split("_")[0];
        boolean wasFound = false;
        ListIterator<String> iter = this.assumptions.listIterator();
        while (iter.hasNext()) {
            String oldAssumption = iter.next();
            String oldLhs = oldAssumption.split("_")[0];
            if (!newLhs.equals(oldLhs)) continue;
            iter.set(assumption);
            wasFound = true;
            break;
        }
        if (!wasFound) {
            this.assumptions.add(assumption);
        }
    }

    @Override
    public void clearAssumptions() {
        this.assumptions.clear();
    }

    @Override
    public void setRelatedLinks(boolean include) {
        this.includeRelatedLinks = include;
    }

    @Override
    public boolean isRelatedLinks() {
        return this.includeRelatedLinks;
    }

    @Override
    public void setReinterpret(boolean allowReinterpret) {
        this.allowReinterpret = allowReinterpret;
    }

    @Override
    public boolean isReinterpret() {
        return this.allowReinterpret;
    }

    @Override
    public void setSignature(String sig) {
        this.signature = sig;
    }

    @Override
    public List<String[]> getExtraParams() {
        return this.extraParams;
    }

    @Override
    public List<String[]> getParameters() {
        int numFormats;
        String[] param;
        ArrayList<String[]> params = new ArrayList<String[]>(15);
        StringBuilder s = new StringBuilder();
        if (this.input != null) {
            param = new String[]{"input", WAQueryParametersImpl.encode(this.input)};
            params.add(param);
        }
        if ((numFormats = this.formats.size()) > 0) {
            param = new String[2];
            param[0] = "format";
            s.setLength(0);
            for (int i = 0; i < numFormats; ++i) {
                s.append(this.formats.get(i));
                if (i >= numFormats - 1) continue;
                s.append(",");
            }
            param[1] = s.toString();
            params.add(param);
        }
        param = new String[]{"async", this.async == 0.0 ? "true" : (this.async > 0.0 ? Double.toString(this.async) : "false")};
        params.add(param);
        if (this.scanTimeout > 0.0) {
            param = new String[]{"scantimeout", Double.toString(this.scanTimeout)};
            params.add(param);
        }
        if (this.podTimeout > 0.0) {
            param = new String[]{"podtimeout", Double.toString(this.podTimeout)};
            params.add(param);
        }
        if (this.formatTimeout > 0.0) {
            param = new String[]{"formattimeout", Double.toString(this.formatTimeout)};
            params.add(param);
        }
        if (this.ip != null) {
            param = new String[]{"ip", this.ip};
            params.add(param);
        }
        if (this.latitude != null && this.longitude != null) {
            param = new String[]{"latlong", Double.toString(this.latitude) + "," + Double.toString(this.longitude)};
            params.add(param);
        }
        if (this.location != null) {
            param = new String[]{"location", WAQueryParametersImpl.encode(this.location)};
            params.add(param);
        }
        if (this.metric != null) {
            param = new String[]{"units", this.metric != false ? "metric" : "nonmetric"};
            params.add(param);
        }
        if (this.currency != null) {
            param = new String[]{"currency", this.currency};
            params.add(param);
        }
        if (this.countryCode != null) {
            param = new String[]{"countrycode", this.countryCode};
            params.add(param);
        }
        if (this.allowTranslation != null) {
            param = new String[]{"translation", this.allowTranslation != false ? "true" : "false"};
            params.add(param);
        }
        if (this.includeRelatedLinks) {
            param = new String[]{"sidebarlinks", "true"};
            params.add(param);
        }
        if (this.allowReinterpret) {
            param = new String[]{"reinterpret", "true"};
            params.add(param);
        }
        for (String t : this.podTitles) {
            param = new String[]{"podtitle", WAQueryParametersImpl.encode(t)};
            params.add(param);
        }
        for (String sc : this.podScanners) {
            param = new String[]{"scanner", sc};
            params.add(param);
        }
        for (Integer i : this.podIndices) {
            param = new String[]{"podindex", Integer.toString(i)};
            params.add(param);
        }
        for (String id : this.includePodIDs) {
            param = new String[]{"includepodid", WAQueryParametersImpl.encode(id)};
            params.add(param);
        }
        for (String id : this.excludePodIDs) {
            param = new String[]{"excludepodid", WAQueryParametersImpl.encode(id)};
            params.add(param);
        }
        for (String a : this.assumptions) {
            param = new String[]{"assumption", a};
            params.add(param);
        }
        for (WAPodState p : this.podStates) {
            param = new String[]{"podstate", WAQueryParametersImpl.encode(p.getInputs()[p.getCurrentIndex()])};
            params.add(param);
        }
        if (this.width > 0) {
            param = new String[]{"width", Integer.toString(this.width)};
            params.add(param);
        }
        if (this.maxWidth > 0) {
            param = new String[]{"maxwidth", Integer.toString(this.maxWidth)};
            params.add(param);
        }
        if (this.plotWidth > 0) {
            param = new String[]{"plotwidth", Integer.toString(this.plotWidth)};
            params.add(param);
        }
        if (this.magnification != 1.0) {
            param = new String[]{"mag", Double.toString(this.magnification)};
            params.add(param);
        }
        for (String[] paramPair : this.extraParams) {
            param = new String[]{paramPair[0], paramPair[1]};
            params.add(param);
        }
        return params;
    }

    private static String encode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    @Override
    public void fillFromURL(String url) {
        List reinterpret;
        List relatedLinks;
        List podStates;
        List assumptions;
        List excludePods;
        List includePods;
        List podIndexes;
        List podScanners;
        List podTitles;
        List allowTranslation;
        List countryCode;
        List currency;
        List units;
        List location;
        List latlong;
        List ip;
        List formats;
        String[] params;
        int questionMarkPos = url.indexOf("?");
        String queryString = url.substring(questionMarkPos + 1);
        HashMap<String, ArrayList<String>> parmsMap = new HashMap<String, ArrayList<String>>();
        for (String param : params = queryString.split("&")) {
            String[] temp = param.split("=");
            if (temp.length != 2) continue;
            try {
                String value = URLDecoder.decode(temp[1], "UTF-8");
                ArrayList<String> values = (ArrayList<String>)parmsMap.get(temp[0]);
                if (values == null) {
                    values = new ArrayList<String>();
                }
                values.add(value);
                parmsMap.put(temp[0], values);
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        List input = (List)parmsMap.get("input");
        if (input != null) {
            this.setInput((String)input.get(0));
        }
        if ((formats = (List)parmsMap.get("format")) != null) {
            String[] fmts;
            for (String fmt : fmts = ((String)formats.get(0)).split(",")) {
                this.addFormat(fmt);
            }
        }
        if ((ip = (List)parmsMap.get("ip")) != null) {
            this.setIP((String)ip.get(0));
        }
        if ((latlong = (List)parmsMap.get("latlong")) != null) {
            this.setLatLong((String)latlong.get(0));
        }
        if ((location = (List)parmsMap.get("location")) != null) {
            this.setLocation((String)location.get(0));
        }
        if ((units = (List)parmsMap.get("units")) != null) {
            this.setMetric(((Object)units).equals("metric"));
        }
        if ((currency = (List)parmsMap.get("currency")) != null) {
            this.setCurrency((String)currency.get(0));
        }
        if ((countryCode = (List)parmsMap.get("countrycode")) != null) {
            this.setCountryCode((String)countryCode.get(0));
        }
        if ((allowTranslation = (List)parmsMap.get("translation")) != null) {
            this.setAllowTranslation(((Object)allowTranslation).equals("true"));
        }
        if ((podTitles = (List)parmsMap.get("podtitle")) != null) {
            for (String title : podTitles) {
                this.addPodTitle(title);
            }
        }
        if ((podScanners = (List)parmsMap.get("podscanner")) != null) {
            for (String scanner : podScanners) {
                this.addPodScanner(scanner);
            }
        }
        if ((podIndexes = (List)parmsMap.get("podindex")) != null) {
            for (String index : podIndexes) {
                this.addPodIndex(Integer.parseInt(index));
            }
        }
        if ((includePods = (List)parmsMap.get("includepodid")) != null) {
            for (String include : includePods) {
                this.addIncludePodID(include);
            }
        }
        if ((excludePods = (List)parmsMap.get("excludepodid")) != null) {
            for (String exclude : excludePods) {
                this.addExcludePodID(exclude);
            }
        }
        if ((assumptions = (List)parmsMap.get("assumption")) != null) {
            for (String a : assumptions) {
                this.addAssumption(a);
            }
        }
        if ((podStates = (List)parmsMap.get("podstate")) != null) {
            for (String state : podStates) {
                this.addPodState(state);
            }
        }
        if ((relatedLinks = (List)parmsMap.get("sidebarlinks")) != null) {
            this.setRelatedLinks(((String)relatedLinks.get(0)).equals("true"));
        }
        if ((reinterpret = (List)parmsMap.get("reinterpret")) != null) {
            this.setReinterpret(((String)reinterpret.get(0)).equals("true"));
        }
        try {
            List formattimeout;
            List podtimeout;
            List scantimeout;
            List async;
            List magnification;
            List plotWidth;
            List maxWidth;
            List width = (List)parmsMap.get("width");
            if (width != null) {
                this.setWidth(Integer.parseInt((String)width.get(0)));
            }
            if ((maxWidth = (List)parmsMap.get("maxwidth")) != null) {
                this.setMaxWidth(Integer.parseInt((String)maxWidth.get(0)));
            }
            if ((plotWidth = (List)parmsMap.get("plotwidth")) != null) {
                this.setPlotWidth(Integer.parseInt((String)plotWidth.get(0)));
            }
            if ((magnification = (List)parmsMap.get("mag")) != null) {
                this.setMagnification(Double.parseDouble((String)magnification.get(0)));
            }
            if ((async = (List)parmsMap.get("async")) != null) {
                String asyncValue = (String)async.get(0);
                if (asyncValue.equals("true")) {
                    this.setAsync(0.0);
                } else if (asyncValue.equals("false")) {
                    this.setAsync(-1.0);
                } else {
                    this.setAsync(Double.parseDouble(asyncValue));
                }
            }
            if ((scantimeout = (List)parmsMap.get("scantimeout")) != null) {
                this.setScanTimeout(Double.parseDouble((String)scantimeout.get(0)));
            }
            if ((podtimeout = (List)parmsMap.get("podtimeout")) != null) {
                this.setPodTimeout(Double.parseDouble((String)podtimeout.get(0)));
            }
            if ((formattimeout = (List)parmsMap.get("formattimeout")) != null) {
                this.setFormatTimeout(Double.parseDouble((String)formattimeout.get(0)));
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
    }

    @Override
    public String toWebsiteURL() {
        StringBuffer url = new StringBuffer("http://www.wolframalpha.com/input/?i=");
        try {
            url.append(URLEncoder.encode(this.input, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        for (String a : this.getAssumptions()) {
            url.append("&a=");
            url.append(a);
        }
        return url.toString();
    }
}

