/*
 * Decompiled with CFR 0.152.
 */
package com.wolfram.alpha.impl;

import com.wolfram.alpha.WAAssumption;
import com.wolfram.alpha.WAExamplePage;
import com.wolfram.alpha.WAException;
import com.wolfram.alpha.WAFutureTopic;
import com.wolfram.alpha.WAPod;
import com.wolfram.alpha.WAQuery;
import com.wolfram.alpha.WAQueryResult;
import com.wolfram.alpha.WARelatedExample;
import com.wolfram.alpha.WARelatedLink;
import com.wolfram.alpha.WASourceInfo;
import com.wolfram.alpha.WAWarning;
import com.wolfram.alpha.impl.WAAssumptionImpl;
import com.wolfram.alpha.impl.WAExamplePageImpl;
import com.wolfram.alpha.impl.WAFutureTopicImpl;
import com.wolfram.alpha.impl.WAPodImpl;
import com.wolfram.alpha.impl.WAReinterpretWarningImpl;
import com.wolfram.alpha.impl.WARelatedExampleImpl;
import com.wolfram.alpha.impl.WARelatedLinkImpl;
import com.wolfram.alpha.impl.WASourceInfoImpl;
import com.wolfram.alpha.impl.WAWarningImpl;
import com.wolfram.alpha.net.HttpProvider;
import com.wolfram.alpha.visitor.Visitable;
import com.wolfram.alpha.visitor.Visitor;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class WAQueryResultImpl
implements WAQueryResult,
Visitable,
Serializable {
    private transient WAQuery query;
    private byte[] bytes;
    private transient File tempDir;
    private transient HttpProvider http;
    private transient Object userData;
    private boolean imagesAcquired = false;
    private boolean success;
    private boolean error;
    private int errorCode = 0;
    private String errorMessage;
    private String[] dataTypes = EMPTY_STRING_ARRAY;
    private String[] timedoutScanners = EMPTY_STRING_ARRAY;
    private double timing;
    private double parseTiming;
    private String version;
    private String recalcURL = "";
    private WAPodImpl[] pods = WAPodImpl.EMPTY_ARRAY;
    private WAAssumptionImpl[] assumptions = WAAssumptionImpl.EMPTY_ARRAY;
    private WAWarningImpl[] warnings = WAWarningImpl.EMPTY_ARRAY;
    private WARelatedLinkImpl[] relatedLinks = WARelatedLinkImpl.EMPTY_ARRAY;
    private WASourceInfoImpl[] sources = WASourceInfoImpl.EMPTY_ARRAY;
    private String[] didYouMeans = EMPTY_STRING_ARRAY;
    private WARelatedExampleImpl[] relatedExamples = WARelatedExampleImpl.EMPTY_ARRAY;
    private String[] languageMessage = EMPTY_STRING_ARRAY;
    private String[] splatTips = EMPTY_STRING_ARRAY;
    private WAFutureTopic futureTopic;
    private WAExamplePage examplePage;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final long serialVersionUID = 6045494030310944812L;

    public WAQueryResultImpl(WAQuery query, byte[] bytes, HttpProvider http, File tempDir) throws WAException {
        this.query = query;
        this.http = http;
        this.bytes = bytes;
        this.tempDir = tempDir;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(new ByteArrayInputStream(bytes));
            this.createFromDOM(doc.getDocumentElement());
        }
        catch (ParserConfigurationException e) {
            throw new WAException(e);
        }
        catch (FactoryConfigurationError e) {
            throw new WAException(e);
        }
        catch (IOException e) {
            throw new WAException(e);
        }
        catch (SAXException e) {
            throw new WAException(e);
        }
    }

    public boolean isSuccess() {
        return this.success;
    }

    public boolean isError() {
        return this.error;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public WAQuery getQuery() {
        return this.query;
    }

    public int getNumPods() {
        return this.pods.length;
    }

    public String[] getDataTypes() {
        return this.dataTypes;
    }

    public String[] getTimedoutScanners() {
        return this.timedoutScanners;
    }

    public double getTiming() {
        return this.timing;
    }

    public double getParseTiming() {
        return this.parseTiming;
    }

    public String getAPIVersion() {
        return this.version;
    }

    public String getRecalculateURL() {
        return this.recalcURL;
    }

    public synchronized WAPod[] getPods() {
        return this.pods;
    }

    public WAAssumption[] getAssumptions() {
        return this.assumptions;
    }

    public WAWarning[] getWarnings() {
        return this.warnings;
    }

    public String[] getTips() {
        return this.splatTips;
    }

    public WARelatedLink[] getRelatedLinks() {
        return this.relatedLinks;
    }

    public WASourceInfo[] getSources() {
        return this.sources;
    }

    public String[] getDidYouMeans() {
        return this.didYouMeans;
    }

    public WARelatedExample[] getRelatedExamples() {
        return this.relatedExamples;
    }

    public String[] getLanguageMessage() {
        return this.languageMessage;
    }

    public WAFutureTopic getFutureTopic() {
        return this.futureTopic;
    }

    public WAExamplePage getExamplePage() {
        return this.examplePage;
    }

    public synchronized void acquireImages() {
        if (!this.imagesAcquired) {
            for (WAPodImpl pod : this.pods) {
                try {
                    pod.acquireImages();
                }
                catch (WAException e) {
                    // empty catch block
                }
            }
            this.imagesAcquired = true;
        }
    }

    public void finishAsync() {
        this.acquireImages();
        ArrayList<Thread> runningThreads = new ArrayList<Thread>(this.pods.length);
        WAPod[] pods = this.getPods();
        for (int i = 0; i < pods.length; ++i) {
            final WAPod pod = pods[i];
            if (pod.getAsyncURL() == null) continue;
            Thread t = new Thread(new Runnable(){

                public void run() {
                    try {
                        pod.finishAsync();
                    }
                    catch (WAException wAException) {
                        // empty catch block
                    }
                }
            });
            t.start();
            runningThreads.add(t);
        }
        for (Thread t : runningThreads) {
            try {
                t.join();
            }
            catch (InterruptedException e) {}
        }
    }

    public synchronized void mergeRecalculateResult(WAQueryResult recalcQueryResult) {
        WAPod[] recalcPods = recalcQueryResult.getPods();
        WAPod[] oldPods = this.getPods();
        if (recalcPods.length > 0) {
            WAPodImpl[] allPods = new WAPodImpl[oldPods.length + recalcPods.length];
            System.arraycopy(oldPods, 0, allPods, 0, oldPods.length);
            System.arraycopy(recalcPods, 0, allPods, oldPods.length, recalcPods.length);
            this.pods = allPods;
        }
    }

    public synchronized void mergePodstateResult(WAQueryResult podstateQueryResult) {
        WAPod[] newPods = podstateQueryResult.getPods();
        if (newPods.length == 1) {
            WAPod newPod = newPods[0];
            String podTitle = newPod.getTitle();
            WAPod[] oldPods = this.getPods();
            for (int i = 0; i < oldPods.length; ++i) {
                if (!podTitle.equals(oldPods[i].getTitle())) continue;
                oldPods[i] = newPod;
                break;
            }
        }
    }

    public String getXML() {
        try {
            return new String(this.bytes, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public void release() {
    }

    public void setUserData(Object obj) {
        this.userData = obj;
    }

    public Object getUserData() {
        return this.userData;
    }

    private void createFromDOM(Element thisElement) throws WAException {
        this.success = thisElement.getAttribute("success").equals("true");
        this.error = thisElement.getAttribute("error").equals("true");
        if (this.error) {
            NodeList children = thisElement.getElementsByTagName("error");
            if (children.getLength() > 0) {
                Element errorElement = (Element)children.item(0);
                if ((children = errorElement.getElementsByTagName("code")).getLength() > 0) {
                    try {
                        this.errorCode = Integer.parseInt(children.item(0).getFirstChild().getNodeValue());
                        children.item(0).getFirstChild();
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                if ((children = errorElement.getElementsByTagName("msg")).getLength() > 0) {
                    this.errorMessage = children.item(0).getFirstChild().getNodeValue();
                }
            }
        } else {
            NodeList examplePageElements;
            NodeList futureTopicElements;
            NodeList sourcesElements;
            NodeList languageMsgElements;
            int numLanugageMsgs;
            NodeList relatedExampleElements;
            int numRelatedExamples;
            NodeList tipsElements;
            int i;
            try {
                this.timing = Double.parseDouble(thisElement.getAttribute("timing"));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            try {
                this.parseTiming = Double.parseDouble(thisElement.getAttribute("timing"));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            this.version = thisElement.getAttribute("version");
            this.dataTypes = thisElement.getAttribute("datatypes").split(",");
            this.timedoutScanners = thisElement.getAttribute("timedout").split(",");
            this.recalcURL = thisElement.getAttribute("recalculate");
            NodeList podElements = thisElement.getElementsByTagName("pod");
            int numPods = podElements.getLength();
            this.pods = new WAPodImpl[numPods];
            for (int i2 = 0; i2 < numPods; ++i2) {
                this.pods[i2] = new WAPodImpl((Element)podElements.item(i2), this.http, this.tempDir);
            }
            NodeList assumptionElements = thisElement.getElementsByTagName("assumption");
            int numAssums = assumptionElements.getLength();
            this.assumptions = new WAAssumptionImpl[numAssums];
            for (int i3 = 0; i3 < numAssums; ++i3) {
                this.assumptions[i3] = new WAAssumptionImpl((Element)assumptionElements.item(i3));
            }
            NodeList warningsElements = thisElement.getElementsByTagName("warnings");
            if (warningsElements.getLength() > 0) {
                Element warningsElement = (Element)warningsElements.item(0);
                NodeList children = warningsElement.getChildNodes();
                int numNodes = children.getLength();
                ArrayList<Element> warningElements = new ArrayList<Element>();
                for (int i4 = 0; i4 < numNodes; ++i4) {
                    Node child = children.item(i4);
                    if (!(child instanceof Element)) continue;
                    warningElements.add((Element)child);
                }
                int numWarnings = warningElements.size();
                this.warnings = new WAWarningImpl[numWarnings];
                for (i = 0; i < numWarnings; ++i) {
                    Element warningElement = (Element)warningElements.get(i);
                    this.warnings[i] = "reinterpret".equals(warningElement.getNodeName()) ? new WAReinterpretWarningImpl(warningElement) : new WAWarningImpl(warningElement);
                }
            }
            if ((tipsElements = thisElement.getElementsByTagName("tips")).getLength() > 0) {
                Element tipsElement = (Element)tipsElements.item(0);
                NodeList children = tipsElement.getChildNodes();
                int numNodes = children.getLength();
                ArrayList<Element> tipElements = new ArrayList<Element>();
                for (i = 0; i < numNodes; ++i) {
                    Node child = children.item(i);
                    if (!(child instanceof Element)) continue;
                    tipElements.add((Element)child);
                }
                int numTips = tipElements.size();
                this.splatTips = new String[numTips];
                for (int i5 = 0; i5 < numTips; ++i5) {
                    this.splatTips[i5] = new String(((Element)tipElements.get(i5)).getAttribute("text"));
                }
            }
            NodeList relatedLinkElements = thisElement.getElementsByTagName("sidebarlink");
            int numRelateds = relatedLinkElements.getLength();
            this.relatedLinks = new WARelatedLinkImpl[numRelateds];
            for (int i6 = 0; i6 < numRelateds; ++i6) {
                this.relatedLinks[i6] = new WARelatedLinkImpl((Element)relatedLinkElements.item(i6), this.http, this.tempDir);
            }
            NodeList didYouMeanElements = thisElement.getElementsByTagName("didyoumean");
            int numDidYouMeans = didYouMeanElements.getLength();
            if (numDidYouMeans > 0) {
                this.didYouMeans = new String[numDidYouMeans];
                for (i = 0; i < numDidYouMeans; ++i) {
                    Node textNode = didYouMeanElements.item(i).getFirstChild();
                    this.didYouMeans[i] = textNode.getNodeValue();
                }
            }
            if ((numRelatedExamples = (relatedExampleElements = thisElement.getElementsByTagName("relatedexample")).getLength()) > 0) {
                this.relatedExamples = new WARelatedExampleImpl[numRelatedExamples];
                for (int i7 = 0; i7 < numRelatedExamples; ++i7) {
                    this.relatedExamples[i7] = new WARelatedExampleImpl((Element)relatedExampleElements.item(i7), this.http, this.tempDir);
                }
            }
            if ((numLanugageMsgs = (languageMsgElements = thisElement.getElementsByTagName("languagemsg")).getLength()) > 0) {
                Element languageMsgElement = (Element)languageMsgElements.item(0);
                String english = languageMsgElement.getAttribute("english");
                String foreign = languageMsgElement.getAttribute("other");
                this.languageMessage = new String[]{english, foreign};
            }
            if ((sourcesElements = thisElement.getElementsByTagName("sources")).getLength() > 0) {
                Element sourcesElement = (Element)sourcesElements.item(0);
                NodeList children = sourcesElement.getChildNodes();
                int numNodes = children.getLength();
                ArrayList<Element> sourceElements = new ArrayList<Element>();
                for (int i8 = 0; i8 < numNodes; ++i8) {
                    Node child = children.item(i8);
                    if (!(child instanceof Element)) continue;
                    sourceElements.add((Element)child);
                }
                int numSources = sourceElements.size();
                this.sources = new WASourceInfoImpl[numSources];
                for (int i9 = 0; i9 < numSources; ++i9) {
                    this.sources[i9] = new WASourceInfoImpl((Element)sourceElements.get(i9));
                }
            }
            if ((futureTopicElements = thisElement.getElementsByTagName("futuretopic")).getLength() > 0) {
                this.futureTopic = new WAFutureTopicImpl((Element)futureTopicElements.item(0));
            }
            if ((examplePageElements = thisElement.getElementsByTagName("examplepage")).getLength() > 0) {
                this.examplePage = new WAExamplePageImpl((Element)examplePageElements.item(0));
            }
        }
    }

    public void accept(Visitor v) {
        v.visit(this);
        for (WAPodImpl pod : this.pods) {
            pod.accept(v);
        }
    }
}

