/*
 * Decompiled with CFR 0.152.
 */
package com.wolfram.alpha.impl;

import com.wolfram.alpha.WAException;
import com.wolfram.alpha.WASound;
import com.wolfram.alpha.net.HttpProvider;
import com.wolfram.alpha.net.URLFetcher;
import com.wolfram.alpha.visitor.Visitable;
import com.wolfram.alpha.visitor.Visitor;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import org.w3c.dom.Element;

public class WASoundImpl
implements WASound,
Visitable,
Serializable {
    private String url;
    private String format;
    private volatile File file;
    private volatile int cachedHashCode = 0;
    private volatile boolean soundAcquired = false;
    private transient HttpProvider http;
    private transient File tempDir;
    static final WASoundImpl[] EMPTY_ARRAY = new WASoundImpl[0];
    private static final long serialVersionUID = 3863860206159745210L;

    WASoundImpl(Element thisElement, HttpProvider http, File tempDir) throws WAException {
        this.url = thisElement.getAttribute("url");
        this.format = thisElement.getAttribute("type");
        if (this.format.equals("audio/x-wav")) {
            this.format = "WAV";
        } else if (this.format.equals("audio/midi")) {
            this.format = "MIDI";
        }
        this.http = http;
        this.tempDir = tempDir;
    }

    public String getURL() {
        return this.url;
    }

    public String getFormat() {
        return this.format;
    }

    public synchronized File getFile() {
        return this.file;
    }

    public void acquireSound() {
        if (!this.soundAcquired && this.http != null) {
            if (!this.url.equals("")) {
                try {
                    String suffix = this.format == "WAV" ? ".wav" : (this.format == "MIDI" ? ".mid" : ".tmp");
                    String outFile = File.createTempFile("WASound", suffix, this.tempDir).getAbsolutePath();
                    URLFetcher fetcher = new URLFetcher(new URL(this.url), outFile, this.http, null);
                    fetcher.fetch();
                    this.setFile(fetcher.getFile());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.soundAcquired = true;
        }
    }

    public synchronized int hashCode() {
        if (this.cachedHashCode != 0) {
            return this.cachedHashCode;
        }
        int result = 17;
        result = 37 * result + this.url.hashCode();
        if (this.file != null) {
            result = 37 * result + this.file.hashCode();
        }
        this.cachedHashCode = result;
        return result;
    }

    private synchronized void setFile(File file) {
        this.file = file;
        this.cachedHashCode = 0;
    }

    public void accept(Visitor v) {
        v.visit(this);
    }
}

