/*
 * Decompiled with CFR 0.152.
 */
package com.wolfram.alpha.impl;

import com.wolfram.alpha.WAException;
import com.wolfram.alpha.WAImage;
import com.wolfram.alpha.WAUnits;
import com.wolfram.alpha.impl.WAImageImpl;
import com.wolfram.alpha.net.HttpProvider;
import com.wolfram.alpha.visitor.Visitor;
import java.io.File;
import java.io.Serializable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WAUnitsImpl
implements WAUnits,
Serializable {
    private String[] shortNames;
    private String[] longNames;
    private WAImage image;
    private static final long serialVersionUID = -1635250906549142822L;

    WAUnitsImpl(Element thisElement, HttpProvider http, File tempDir) throws WAException {
        int numUnits = Integer.parseInt(thisElement.getAttribute("count"));
        this.shortNames = new String[numUnits];
        this.longNames = new String[numUnits];
        NodeList subElements = thisElement.getChildNodes();
        int numSubElements = subElements.getLength();
        int unitElementIndex = 0;
        for (int i = 0; i < numSubElements; ++i) {
            Node child = subElements.item(i);
            String name = child.getNodeName();
            if ("unit".equals(name)) {
                Element unit = (Element)child;
                this.shortNames[unitElementIndex] = unit.getAttribute("short");
                this.longNames[unitElementIndex] = unit.getAttribute("long");
                ++unitElementIndex;
                continue;
            }
            if (!"img".equals(name)) continue;
            this.image = new WAImageImpl((Element)child, http, tempDir);
        }
    }

    public WAImage getImage() {
        return this.image;
    }

    public String[] getLongNames() {
        return this.longNames;
    }

    public String[] getShortNames() {
        return this.shortNames;
    }

    public void accept(Visitor v) {
    }
}

