/*
 * Decompiled with CFR 0.152.
 */
package com.wolfram.alpha.net;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpHost;

public class ProxySettings {
    private static ProxySettings instance = null;
    private int useProxy;
    private String httpProxyHost;
    private int httpProxyPort;
    private String proxyUsername;
    private String proxyPassword;
    public static final int PROXY_NONE = 0;
    public static final int PROXY_AUTOMATIC = 1;
    public static final int PROXY_MANUAL = 2;

    private ProxySettings() {
        System.setProperty("java.net.useSystemProxies", "true");
        ProxySelector.setDefault(MyProxySelector.getInstance());
    }

    public static synchronized ProxySettings getInstance() {
        if (instance == null) {
            instance = new ProxySettings();
        }
        return instance;
    }

    public synchronized void setProxyInfo(int useProxy, String httpProxyHost, int httpProxyPort) {
        this.useProxy = useProxy;
        this.httpProxyHost = httpProxyHost;
        this.httpProxyPort = httpProxyPort;
    }

    synchronized int getUseProxy() {
        return this.useProxy;
    }

    synchronized String getProxyUsername() {
        return this.proxyUsername;
    }

    public synchronized void setProxyUsername(String username) {
        this.proxyUsername = username;
    }

    synchronized String getProxyPassword() {
        return this.proxyPassword;
    }

    public synchronized void setProxyPassword(String password) {
        this.proxyPassword = password;
    }

    public synchronized String[] getProxyHostAndPort(String url) {
        int colonPos;
        String protocol;
        int port = 0;
        String host = null;
        if (this.useProxy == 1) {
            ProxySelector ps = ProxySelector.getDefault();
            try {
                URI uri = new URI(url);
                List<Proxy> proxyList = ps.select(uri);
                int len = proxyList.size();
                for (int i = 0; i < len; ++i) {
                    Proxy p = proxyList.get(i);
                    InetSocketAddress addr = (InetSocketAddress)p.address();
                    if (addr == null) continue;
                    host = addr.getHostName();
                    port = addr.getPort();
                }
            }
            catch (Exception e) {}
        } else if (this.useProxy == 2 && (protocol = (colonPos = url.indexOf(58)) != -1 ? url.substring(0, colonPos).toLowerCase() : "http").equals("http")) {
            host = this.httpProxyHost;
            port = this.httpProxyPort;
        }
        return new String[]{host, String.valueOf(port)};
    }

    public synchronized HttpHost getProxyForHttpClient(String url) {
        String[] hostAndPort = this.getProxyHostAndPort(url);
        String host = hostAndPort[0];
        int port = Integer.parseInt(hostAndPort[1]);
        if (port != 0 && host != null) {
            return new HttpHost(host, port, "http");
        }
        return null;
    }

    public synchronized Proxy getProxyForJavaNet(String url) {
        String[] hostAndPort = this.getProxyHostAndPort(url);
        String host = hostAndPort[0];
        int port = Integer.parseInt(hostAndPort[1]);
        if (port != 0 && host != null) {
            return new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, port));
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MyProxySelector
    extends ProxySelector {
        static MyProxySelector instance = null;
        ProxySelector origSelector = null;
        private final List<Proxy> NO_PROXY_LIST = new ArrayList<Proxy>(1);

        private MyProxySelector() {
            this.origSelector = ProxySelector.getDefault();
            this.NO_PROXY_LIST.add(Proxy.NO_PROXY);
        }

        static synchronized ProxySelector getInstance() {
            if (instance == null) {
                instance = new MyProxySelector();
            }
            return instance;
        }

        @Override
        public List<Proxy> select(URI uri) {
            int useProxy = ProxySettings.getInstance().getUseProxy();
            if (useProxy == 1) {
                return this.origSelector.select(uri);
            }
            if (useProxy == 2) {
                Proxy p = ProxySettings.getInstance().getProxyForJavaNet(uri.toString());
                if (p != null) {
                    ArrayList<Proxy> proxies = new ArrayList<Proxy>(1);
                    proxies.add(p);
                    return proxies;
                }
                return this.NO_PROXY_LIST;
            }
            return this.NO_PROXY_LIST;
        }

        @Override
        public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
            this.origSelector.connectFailed(uri, sa, ioe);
        }
    }
}

