/*
 * Decompiled with CFR 0.152.
 */
package com.wolfram.alpha.net.apache;

import com.wolfram.alpha.net.ProxySettings;
import com.wolfram.alpha.net.WAHttpException;
import com.wolfram.alpha.net.impl.HttpTransaction;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.util.EntityUtils;

public class ApacheHttpTransaction
implements HttpTransaction {
    private HttpClient httpClient;
    private HttpGet httpGet;
    private HttpResponse response;
    private HttpEntity entity;
    private URL url;
    private ProxySettings proxySettings;
    private int maxRetryCount;
    private int socketTimeoutMillis;
    private volatile boolean noRetry = false;

    ApacheHttpTransaction(HttpClient httpClient, URL url, ProxySettings proxySettings, int maxRetryCount, int socketTimeoutMillis) {
        this.httpClient = httpClient;
        this.url = url;
        this.proxySettings = proxySettings != null ? proxySettings : ProxySettings.getInstance();
        this.maxRetryCount = maxRetryCount;
        this.socketTimeoutMillis = socketTimeoutMillis;
    }

    public void execute() throws WAHttpException {
        this.httpGet = new HttpGet(this.url.toString());
        HttpHost proxy = this.proxySettings.getProxyForHttpClient(this.url.toString());
        this.httpClient.getParams().setParameter("http.route.default-proxy", (Object)proxy);
        try {
            this.response = this.httpClient.execute((HttpUriRequest)this.httpGet);
            int statusCode = this.response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                throw new WAHttpException(statusCode);
            }
            this.entity = this.response.getEntity();
        }
        catch (Exception e) {
            this.httpGet.abort();
            if (e instanceof WAHttpException) {
                throw (WAHttpException)e;
            }
            throw new WAHttpException(e);
        }
    }

    public void release() {
        if (this.entity != null) {
            try {
                this.entity.consumeContent();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String[][] getResponseHeaders() throws IOException {
        Header[] hdrs = this.response.getAllHeaders();
        String[][] result = new String[hdrs.length][];
        for (int i = 0; i < hdrs.length; ++i) {
            result[i] = new String[]{hdrs[i].getName(), hdrs[i].getValue()};
        }
        return result;
    }

    public String getResponseHeader(String headerName) throws IOException {
        Header hdr = this.response.getFirstHeader(headerName);
        return hdr == null ? null : hdr.getValue();
    }

    public long getContentLength() {
        return this.entity == null ? -1L : this.entity.getContentLength();
    }

    public String getCharSet() throws IOException {
        return EntityUtils.getContentCharSet((HttpEntity)this.entity);
    }

    public InputStream getResponseStream() throws IOException {
        return this.entity.getContent();
    }

    public String getResponseString() throws IOException {
        return EntityUtils.toString((HttpEntity)this.entity);
    }

    public void setNoRetry() {
        this.noRetry = true;
    }

    public void abort() {
        this.httpGet.abort();
    }
}

