/*
 * Decompiled with CFR 0.152.
 */
package com.wolfram.alpha.net.j2se;

import com.wolfram.alpha.net.ProxySettings;
import com.wolfram.alpha.net.WAHttpException;
import com.wolfram.alpha.net.impl.HttpTransaction;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;

public class J2SEHttpTransaction
implements HttpTransaction {
    private HttpURLConnection conn;
    private URL url;
    private String userAgent;
    private ProxySettings proxySettings;

    J2SEHttpTransaction(URL url, ProxySettings proxySettings, String userAgent) {
        this.url = url;
        this.userAgent = userAgent;
        this.proxySettings = proxySettings != null ? proxySettings : ProxySettings.getInstance();
    }

    public void abort() {
    }

    public void execute() throws WAHttpException {
        try {
            Proxy proxy = this.proxySettings.getProxyForJavaNet(this.url.toString());
            this.conn = proxy != null ? (HttpURLConnection)this.url.openConnection(proxy) : (HttpURLConnection)this.url.openConnection();
            this.conn.setRequestMethod("GET");
            this.conn.setReadTimeout(15000);
            this.conn.connect();
            int statusCode = this.conn.getResponseCode();
            if (statusCode != 200) {
                String ignoredButMustRead = this.getResponseString();
                throw new WAHttpException(statusCode);
            }
        }
        catch (IOException e) {
            throw new WAHttpException(e);
        }
    }

    public long getContentLength() {
        return this.conn.getContentLength();
    }

    public String getCharSet() throws IOException {
        String contentType = this.conn.getContentType();
        String charset = "ISO-8859-1";
        return charset;
    }

    public String[][] getResponseHeaders() throws IOException {
        return null;
    }

    public InputStream getResponseStream() throws IOException {
        return this.conn.getInputStream();
    }

    public String getResponseString() throws IOException {
        int len;
        InputStream strm = this.conn.getInputStream();
        if (strm == null) {
            return null;
        }
        int contentLength = (int)this.getContentLength();
        ByteArrayOutputStream outStrm = new ByteArrayOutputStream(contentLength);
        byte[] buf = new byte[8192];
        while ((len = strm.read(buf)) > 0) {
            outStrm.write(buf, 0, len);
        }
        outStrm.close();
        try {
            return new String(outStrm.toByteArray(), "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    public void release() {
        try {
            InputStream strm;
            if (this.conn != null && (strm = this.conn.getInputStream()) != null) {
                strm.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setNoRetry() {
    }
}

